<?php
/**
 * User: Dre
 * Date: 8-12-2016
 * Time: 16:20
 */

namespace ConscriboConnector\Request;

use ConscriboConnector\ConscriboConnector;
use ConscriboConnector\Request;

Class ReplaceRelationRequest extends Request {

	/**
	 * @var mixed[]
	 */
	private $changes;

	/**
	 * @var string 'new' | 'update'
	 */
	private $mode;

	/**
	 * @var String
	 */
	private $currentRelationNr;


	public function setModeUpdateRelation($relationNr) {
		$this->mode = 'update';
		$this->currentRelationNr = $relationNr;
		return $this;
	}

	public function setModeNewRelation() {
		$this->mode = 'new';
		$this->currentRelationNr = NULL;
		return $this;
	}

	public function setValue($fieldName, $newValue) {
		$this->changes[$fieldName] = $newValue;
	}


	protected function getJSONRequest(ConscriboConnector $connector) {
		$request = array('command' => 'replaceRelation',
			'fields' => $this->changes);

		if($this->mode =='update') {
			$request['code'] = $this->currentRelationNr;
		}
		return $request;

	}
}